/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service;

import java.util.List;
import java.util.Vector;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.chefproject.core.CandidateInfo;
import org.chefproject.core.CandidateInfoEdit;
import org.chefproject.core.CandidatePath;
import org.chefproject.core.CandidatePathEdit;
import org.chefproject.core.Dissertation;
import org.chefproject.core.DissertationEdit;
import org.chefproject.core.DissertationStep;
import org.chefproject.core.DissertationStepEdit;
import org.chefproject.core.StepStatus;
import org.chefproject.core.StepStatusEdit;
import org.chefproject.core.User;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.generic.GenericDissertationService;
import org.w3c.dom.Element;

public class DissertationService {
    public static final String REFERENCE_ROOT = "/dissertation";
    protected static GenericDissertationService M_service;

    protected static void find() {
        if (M_service == null && (M_service = (GenericDissertationService)((Object)TurbineServices.getInstance().getService(GenericDissertationService.SERVICE_NAME))) == null) {
            Log.warn("chef", "DissertationService.find: missing service: " + GenericDissertationService.SERVICE_NAME);
        }
    }

    public static GenericDissertationService getInstance() {
        DissertationService.find();
        return M_service;
    }

    public static boolean allowAddDissertation(String site) {
        DissertationService.find();
        return M_service.allowAddDissertation(site);
    }

    public static boolean allowGetDissertation(String dissertationReference) {
        DissertationService.find();
        return M_service.allowGetDissertation(dissertationReference);
    }

    public static boolean allowUpdateDissertation(String dissertationReference) {
        DissertationService.find();
        return M_service.allowUpdateDissertation(dissertationReference);
    }

    public static boolean allowRemoveDissertation(String dissertationReference) {
        DissertationService.find();
        return M_service.allowRemoveDissertation(dissertationReference);
    }

    public static boolean allowAddDissertationStep(String site) {
        DissertationService.find();
        return M_service.allowAddDissertationStep(site);
    }

    public static boolean allowGetDissertationStep(String stepReference) {
        DissertationService.find();
        return M_service.allowGetDissertationStep(stepReference);
    }

    public static boolean allowUpdateDissertationStep(String stepReference) {
        DissertationService.find();
        return M_service.allowUpdateDissertationStep(stepReference);
    }

    public static boolean allowRemoveDissertationStep(String stepReference) {
        DissertationService.find();
        return M_service.allowRemoveDissertationStep(stepReference);
    }

    public static boolean allowAddCandidatePath(String site) {
        DissertationService.find();
        return M_service.allowAddCandidatePath(site);
    }

    public static boolean allowGetCandidatePath(String pathReference) {
        DissertationService.find();
        return M_service.allowGetCandidatePath(pathReference);
    }

    public static boolean allowUpdateCandidatePath(String pathReference) {
        DissertationService.find();
        return M_service.allowUpdateCandidatePath(pathReference);
    }

    public static boolean allowUpdateCandidatePathComm(String pathReference) {
        DissertationService.find();
        return M_service.allowUpdateCandidatePathComm(pathReference);
    }

    public static boolean allowRemoveCandidatePath(String pathReference) {
        DissertationService.find();
        return M_service.allowRemoveCandidatePath(pathReference);
    }

    public static boolean allowAddStepStatus(String site) {
        DissertationService.find();
        return M_service.allowAddStepStatus(site);
    }

    public static boolean allowGetStepStatus(String statusReference) {
        DissertationService.find();
        return M_service.allowGetStepStatus(statusReference);
    }

    public static boolean allowUpdateStepStatus(String statusReference) {
        DissertationService.find();
        return M_service.allowUpdateStepStatus(statusReference);
    }

    public static boolean allowRemoveStepStatus(String statusReference) {
        DissertationService.find();
        return M_service.allowRemoveStepStatus(statusReference);
    }

    public static boolean allowAddCandidateInfo(String site) {
        DissertationService.find();
        return M_service.allowAddCandidateInfo(site);
    }

    public static boolean allowGetCandidateInfo(String infoReference) {
        DissertationService.find();
        return M_service.allowGetCandidateInfo(infoReference);
    }

    public static boolean allowUpdateCandidateInfo(String infoReference) {
        DissertationService.find();
        return M_service.allowUpdateCandidateInfo(infoReference);
    }

    public static boolean allowRemoveCandidateInfo(String infoReference) {
        DissertationService.find();
        return M_service.allowRemoveCandidateInfo(infoReference);
    }

    public static String getParentSiteForUser(String userId) {
        DissertationService.find();
        return M_service.getParentSiteForUser(userId);
    }

    public static String getEmplidForUser(String userId) {
        DissertationService.find();
        return M_service.getEmplidForUser(userId);
    }

    public static String getSchoolSite() {
        DissertationService.find();
        return M_service.getSchoolSite();
    }

    public static boolean hasCandidateInfos() {
        DissertationService.find();
        return M_service.hasCandidateInfos();
    }

    public static DissertationEdit addDissertation(String site) throws PermissionException {
        DissertationService.find();
        return M_service.addDissertation(site);
    }

    public static DissertationEdit mergeDissertation(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        DissertationService.find();
        return M_service.mergeDissertation(el);
    }

    public static Dissertation getDissertation(String dissertationReference) throws IdUnusedException, PermissionException {
        DissertationService.find();
        return M_service.getDissertation(dissertationReference);
    }

    public static void removeDissertation(DissertationEdit dissertation) throws PermissionException {
        DissertationService.find();
        M_service.removeDissertation(dissertation);
    }

    public static DissertationEdit editDissertation(String reference) throws IdUnusedException, PermissionException, InUseException {
        DissertationService.find();
        return M_service.editDissertation(reference);
    }

    public static void commitEdit(DissertationEdit dissertation) {
        DissertationService.find();
        M_service.commitEdit(dissertation);
    }

    public static void cancelEdit(DissertationEdit dissertation) {
        DissertationService.find();
        M_service.cancelEdit(dissertation);
    }

    public static DissertationStepEdit addDissertationStep(String site) throws PermissionException {
        DissertationService.find();
        return M_service.addDissertationStep(site);
    }

    public static DissertationStepEdit mergeDissertationStep(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        DissertationService.find();
        return M_service.mergeDissertationStep(el);
    }

    public static DissertationStep getDissertationStep(String stepReference) throws IdUnusedException, PermissionException {
        DissertationService.find();
        return M_service.getDissertationStep(stepReference);
    }

    public static void removeDissertationStep(DissertationStepEdit step) throws PermissionException {
        DissertationService.find();
        M_service.removeDissertationStep(step);
    }

    public static DissertationStepEdit editDissertationStep(String stepReference) throws IdUnusedException, PermissionException, InUseException {
        DissertationService.find();
        return M_service.editDissertationStep(stepReference);
    }

    public static void commitEdit(DissertationStepEdit step) {
        DissertationService.find();
        M_service.commitEdit(step);
    }

    public static void cancelEdit(DissertationStepEdit step) {
        DissertationService.find();
        M_service.cancelEdit(step);
    }

    public static CandidatePathEdit addCandidatePath(Dissertation dissertation, String site) throws PermissionException {
        DissertationService.find();
        return M_service.addCandidatePath(dissertation, site);
    }

    public static CandidatePathEdit mergeCandidatePath(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        return M_service.mergeCandidatePath(el);
    }

    public static CandidatePath getCandidatePath(String pathReference) throws IdUnusedException, PermissionException {
        DissertationService.find();
        return M_service.getCandidatePath(pathReference);
    }

    public static void removeCandidatePath(CandidatePathEdit path) throws PermissionException {
        DissertationService.find();
        M_service.removeCandidatePath(path);
    }

    public static CandidatePathEdit editCandidatePath(String reference) throws IdUnusedException, PermissionException, InUseException {
        DissertationService.find();
        return M_service.editCandidatePath(reference);
    }

    public static void commitEdit(CandidatePathEdit path) {
        DissertationService.find();
        M_service.commitEdit(path);
    }

    public static void cancelEdit(CandidatePathEdit path) {
        DissertationService.find();
        M_service.cancelEdit(path);
    }

    public static StepStatusEdit addStepStatus(String site) throws PermissionException {
        DissertationService.find();
        return M_service.addStepStatus(site);
    }

    public static StepStatusEdit mergeStepStatus(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        return M_service.mergeStepStatus(el);
    }

    public static StepStatus getStepStatus(String pathReference) throws IdUnusedException, PermissionException {
        DissertationService.find();
        return M_service.getStepStatus(pathReference);
    }

    public static void removeStepStatus(StepStatusEdit status) throws PermissionException {
        DissertationService.find();
        M_service.removeStepStatus(status);
    }

    public static StepStatusEdit editStepStatus(String reference) throws IdUnusedException, PermissionException, InUseException {
        DissertationService.find();
        return M_service.editStepStatus(reference);
    }

    public static void commitEdit(StepStatusEdit status) {
        DissertationService.find();
        M_service.commitEdit(status);
    }

    public static void cancelEdit(StepStatusEdit status) {
        DissertationService.find();
        M_service.cancelEdit(status);
    }

    public static CandidateInfoEdit addCandidateInfo(String site) throws PermissionException {
        DissertationService.find();
        return M_service.addCandidateInfo(site);
    }

    public static CandidateInfoEdit addCandidateInfoFromListener(String site) {
        DissertationService.find();
        return M_service.addCandidateInfoFromListener(site);
    }

    public static CandidateInfoEdit mergeCandidateInfo(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        return M_service.mergeCandidateInfo(el);
    }

    public static CandidateInfo getCandidateInfo(String infoReference) throws IdUnusedException, PermissionException {
        DissertationService.find();
        return M_service.getCandidateInfo(infoReference);
    }

    public static CandidateInfoEdit getCandidateInfoEditForEmplid(String emplid) throws PermissionException {
        DissertationService.find();
        return M_service.getCandidateInfoEditForEmplid(emplid);
    }

    public static void removeCandidateInfo(CandidateInfoEdit info) throws PermissionException {
        DissertationService.find();
        M_service.removeCandidateInfo(info);
    }

    public static CandidateInfoEdit editCandidateInfo(String reference) throws IdUnusedException, PermissionException, InUseException {
        DissertationService.find();
        return M_service.editCandidateInfo(reference);
    }

    public static void commitEdit(CandidateInfoEdit info) {
        DissertationService.find();
        M_service.commitEdit(info);
    }

    public static void cancelEdit(CandidateInfoEdit info) {
        DissertationService.find();
        M_service.cancelEdit(info);
    }

    public static List getCandidatePathsForParentSite(String site) {
        DissertationService.find();
        return M_service.getCandidatePathsForParentSite(site);
    }

    public static CandidatePath getCandidatePathForCandidate(String candidateId) throws PermissionException {
        DissertationService.find();
        return M_service.getCandidatePathForCandidate(candidateId);
    }

    public static Dissertation getDissertationForSite(String site) throws IdUnusedException, PermissionException {
        DissertationService.find();
        return M_service.getDissertationForSite(site);
    }

    public static List getDissertations() {
        DissertationService.find();
        return M_service.getDissertations();
    }

    public static List getDissertationSteps() {
        DissertationService.find();
        return M_service.getDissertationSteps();
    }

    public static List getCandidatePaths() {
        DissertationService.find();
        return M_service.getCandidatePaths();
    }

    public static boolean getActivePaths() {
        DissertationService.find();
        return M_service.getActivePaths();
    }

    public static boolean getActivePathsForSite(String site) {
        DissertationService.find();
        return M_service.getActivePathsForSite(site);
    }

    public static User[] getAllUsersForSite(String site) {
        DissertationService.find();
        return M_service.getAllUsersForSite(site);
    }

    public static boolean getIsCandidate(String userId) {
        DissertationService.find();
        return M_service.getIsCandidate(userId);
    }

    public static void dumpData(Vector v) {
        DissertationService.find();
        M_service.dumpData(v);
    }

    public static boolean getIsInitialized() {
        DissertationService.find();
        return M_service.getIsInitialized();
    }

    public static String getProgram(String fos) {
        DissertationService.find();
        return M_service.getProgram(fos);
    }

    static {
        REFERENCE_ROOT = REFERENCE_ROOT;
        M_service = null;
    }
}

