#' rkTeaching
#'
#' Un plugin de RKWard para la enseñanza de Estadística
#' 
#' Este paquete proporciona un nuevo menú \code{Teaching} a la interfaz gráfica RKWard de R.
#' El nuevo menú incorpora procedimientos para la realización de análisis de estadísticos básicos. 
#' Los cuadros de diálogo están especialmente diseñados para realizar los procedimientos estadísticos de manera sencilla 
#' y facilitar así el aprendizaje de Estadística sin necesidad de utilizar R en línea de comandos.
#' 
#' Contiene procedimientos para:
#' \itemize{
#' 	\item Manipulación de datos:
#' 	\itemize{
#' 		\item Filtrado de datos
#'      \item Cálculo de variables
#'      \item Recodificación de variables
#'      \item Ponderación de datos
#'      \item Tipificación de variables
#' 	}
#'  \item Distribuciones de frecuencias:
#' 	\itemize{
#'      \item Tablas de frecuencias
#'      \item Tablas de frecuencias bidimensionales
#' 	}
#' 	\item Gráficos:
#'  \itemize{
#'      \item Diagrama de barras
#'      \item Histograma
#'      \item Diagrama de sectores
#'      \item Diagrama de cajas
#'      \item Diagrama de medias
#'      \item Diagrama de interacción
#'      \item Diagrama de dispersión
#'      \item Matriz de dispersión
#'  }
#'  \item Estadísticos descriptivos:
#'  \itemize{
#'      \item Estadísticos
#'      \item Cálculo detallado
#'  }
#'  \item Regresión:
#'  \itemize{
#'      \item Regresión lineal
#'      \item Regresión no lineal
#'      \item Comparación de modelos de regresión
#'      \item Predicciones de regresión
#'      \item Correlación
#'  }
#'  \item Test paramétricos:
#'  \itemize{
#'      \item Medias:
#'      \itemize{
#'      	\item Test T para una muestra
#'      	\item Test T para dos muestras independientes
#'      	\item Test T para dos muestras pareadas
#'      	\item ANOVA
#'      	\item Cálculo del tamaño muestral para la media 
#'      	\item Cálculo del tamaño muestral para el test T
#'      }
#'      \item Varianzas:
#'      \itemize{
#'      	\item Test de Fisher
#'      	\item Test de Levene
#'      }
#'      \item Proporciones:
#'      \itemize{ 
#'      	\item Test para una proporción
#'      	\item Test para dos proporciones
#'      	\item Cálculo del tamaño muestral para una proporción
#'      }
#'  }
#'  \item Test no paramétricos
#'  \itemize{
#'      \item Normalidad: 
#'      \itemize{
#'      	\item Test de Lillieford (Komogorov-Smirnov)
#'      	\item Test de Shapiro-Wilk
#'      }
#'      \item Test de la U de Mann-Whitney para dos muestras independientes
#'      \item Test de Wilcoxon para dos muestras pareadas
#' 		\item Test de Kruskal-Wallis para varias muestras independientes
#'      \item Test de Friedman para medidas repetidas
#'      \item Test Chi-cuadrado de independencia
#'      \item Test Chi-cuadrado de bondad de ajuste
#'  }
#'  \item Concordancia:
#'  \itemize{
#'      \item Coeficiente de correlación intraclase
#'      \item Kappa de Cohen
#'  }
#'  \item Distribuciones:
#'  \itemize{
#'      \item Discretas:
#'      \itemize{
#'      	\item Binomial
#'      	\item Poisson
#'      }
#'      \item Continuas:
#'      \itemize{
#'      	\item Uniforme
#'      	\item Normal
#'      	\item Chi-cuadrado
#'      	\item T de student
#'      	\item F de Fisher
#'      }
#'  }
#'  \item Simulaciones:
#'  \itemize{
#'      \item Lanzamiento de monedas
#'      \item Lanzamiento de dados
#'      \item Ley de los casos raros
#'      \item Teorema central del límite
#'  }
#' 
#' @name rkTeaching
#' @docType package
#' @import  car, e1071, ez, ggplot2, Hmisc, plyr, R2HTML
NULL