% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R.comment.R
\name{R.comment}
\alias{R.comment}
\title{Create R comment with JavaScript in RKWard plugin code}
\usage{
R.comment(
  ...,
  indent.by = rk.get.indent(escape = TRUE),
  level = 2,
  newline = ""
)
}
\arguments{
\item{...}{Character strings to form a comment.}

\item{indent.by}{A character string defining the indentation string to use. Note that
backslashes need to be escaped (e.g. \code{"\\t"} to produce \code{"\t"}).}

\item{level}{Integer, which indentation level to use in the resulting R code,
      minimum is 1.}

\item{newline}{Character string,
      can be set to e.g. \code{"\n"} to force a newline after the call.}
}
\value{
A character string.
}
\description{
Create R comment with JavaScript in RKWard plugin code
}
\examples{
cat(R.comment("This will become an R comment"))
}
