% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.text.R
\name{rk.XML.text}
\alias{rk.XML.text}
\title{Create XML node "text" for RKWard plugins}
\usage{
rk.XML.text(text, type = "normal", id.name = "auto", i18n = NULL)
}
\arguments{
\item{text}{Character string, the text to be displayed.}

\item{type}{One value of either "normal", "warning" or "error".}

\item{id.name}{Character string, a unique ID for this plugin element.
If \code{"auto"}, an ID will be generated automatically from \code{text}.
If \code{NULL}, no ID will be given.}

\item{i18n}{Either a character string or a named list with the optional elements \code{context}
or \code{comment}, to give some \code{i18n_context} information for this node.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
Create XML node "text" for RKWard plugins
}
\examples{
test.text <- rk.XML.text("Added this text.")
cat(pasteXML(test.text))
}
\seealso{
\href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
