% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.rkh.label.R
\name{rk.rkh.label}
\alias{rk.rkh.label}
\title{Create XML "label" node for RKWard help pages}
\usage{
rk.rkh.label(id, i18n = NULL)
}
\arguments{
\item{id}{Either a character string (the \code{id} name of the element in the plugin, of
which to copy the \code{label} attribute), or an object of class \code{XiMpLe.node}
(whose \code{id} will be extracted and used).}

\item{i18n}{Either a character string or a named list with the optional elements \code{context}
or \code{comment}, to give some \code{i18n_context} information for this node.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
Create XML "label" node for RKWard help pages
}
\examples{
test.cbox <- rk.XML.cbox(label="foo", value="bar")
(test.label <- rk.rkh.label(test.cbox))
}
\seealso{
\code{\link[rkwarddev:rk.rkh.doc]{rk.rkh.doc}}
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
