/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta1 "k8s.io/api/rbac/v1beta1"
	rbacv1beta1 "k8s.io/client-go/applyconfigurations/rbac/v1beta1"
	gentype "k8s.io/client-go/gentype"
	typedrbacv1beta1 "k8s.io/client-go/kubernetes/typed/rbac/v1beta1"
)

// fakeRoles implements RoleInterface
type fakeRoles struct {
	*gentype.FakeClientWithListAndApply[*v1beta1.Role, *v1beta1.RoleList, *rbacv1beta1.RoleApplyConfiguration]
	Fake *FakeRbacV1beta1
}

func newFakeRoles(fake *FakeRbacV1beta1, namespace string) typedrbacv1beta1.RoleInterface {
	return &fakeRoles{
		gentype.NewFakeClientWithListAndApply[*v1beta1.Role, *v1beta1.RoleList, *rbacv1beta1.RoleApplyConfiguration](
			fake.Fake,
			namespace,
			v1beta1.SchemeGroupVersion.WithResource("roles"),
			v1beta1.SchemeGroupVersion.WithKind("Role"),
			func() *v1beta1.Role { return &v1beta1.Role{} },
			func() *v1beta1.RoleList { return &v1beta1.RoleList{} },
			func(dst, src *v1beta1.RoleList) { dst.ListMeta = src.ListMeta },
			func(list *v1beta1.RoleList) []*v1beta1.Role { return gentype.ToPointerSlice(list.Items) },
			func(list *v1beta1.RoleList, items []*v1beta1.Role) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
