/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha3

import (
	context "context"

	resourcev1alpha3 "k8s.io/api/resource/v1alpha3"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	applyconfigurationsresourcev1alpha3 "k8s.io/client-go/applyconfigurations/resource/v1alpha3"
	gentype "k8s.io/client-go/gentype"
	scheme "k8s.io/client-go/kubernetes/scheme"
)

// ResourceClaimTemplatesGetter has a method to return a ResourceClaimTemplateInterface.
// A group's client should implement this interface.
type ResourceClaimTemplatesGetter interface {
	ResourceClaimTemplates(namespace string) ResourceClaimTemplateInterface
}

// ResourceClaimTemplateInterface has methods to work with ResourceClaimTemplate resources.
type ResourceClaimTemplateInterface interface {
	Create(ctx context.Context, resourceClaimTemplate *resourcev1alpha3.ResourceClaimTemplate, opts v1.CreateOptions) (*resourcev1alpha3.ResourceClaimTemplate, error)
	Update(ctx context.Context, resourceClaimTemplate *resourcev1alpha3.ResourceClaimTemplate, opts v1.UpdateOptions) (*resourcev1alpha3.ResourceClaimTemplate, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*resourcev1alpha3.ResourceClaimTemplate, error)
	List(ctx context.Context, opts v1.ListOptions) (*resourcev1alpha3.ResourceClaimTemplateList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *resourcev1alpha3.ResourceClaimTemplate, err error)
	Apply(ctx context.Context, resourceClaimTemplate *applyconfigurationsresourcev1alpha3.ResourceClaimTemplateApplyConfiguration, opts v1.ApplyOptions) (result *resourcev1alpha3.ResourceClaimTemplate, err error)
	ResourceClaimTemplateExpansion
}

// resourceClaimTemplates implements ResourceClaimTemplateInterface
type resourceClaimTemplates struct {
	*gentype.ClientWithListAndApply[*resourcev1alpha3.ResourceClaimTemplate, *resourcev1alpha3.ResourceClaimTemplateList, *applyconfigurationsresourcev1alpha3.ResourceClaimTemplateApplyConfiguration]
}

// newResourceClaimTemplates returns a ResourceClaimTemplates
func newResourceClaimTemplates(c *ResourceV1alpha3Client, namespace string) *resourceClaimTemplates {
	return &resourceClaimTemplates{
		gentype.NewClientWithListAndApply[*resourcev1alpha3.ResourceClaimTemplate, *resourcev1alpha3.ResourceClaimTemplateList, *applyconfigurationsresourcev1alpha3.ResourceClaimTemplateApplyConfiguration](
			"resourceclaimtemplates",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *resourcev1alpha3.ResourceClaimTemplate { return &resourcev1alpha3.ResourceClaimTemplate{} },
			func() *resourcev1alpha3.ResourceClaimTemplateList {
				return &resourcev1alpha3.ResourceClaimTemplateList{}
			},
			gentype.PrefersProtobuf[*resourcev1alpha3.ResourceClaimTemplate](),
		),
	}
}
