/* $Id: Pssm.cpp 124526 2008-04-15 15:27:44Z camacho $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'scoremat.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/scoremat/Pssm.hpp>

// generated classes

#include <objects/scoremat/PssmFinalData.hpp>
#include <objects/seqset/Seq_entry.hpp>
#include <objects/seq/Bioseq.hpp>
#include <objects/seq/Seq_inst.hpp>
#include <objects/seq/Seq_data.hpp>
#include <objects/seq/seqport_util.hpp>

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CPssm::~CPssm(void)
{
}

SIZE_TYPE
CPssm::GetQueryLength() const
{
    SIZE_TYPE retval = 0;

    if ( !CanGetQuery() ||
         !GetQuery().IsSeq() ||
         !GetQuery().GetSeq().CanGetInst() ||
         !GetQuery().GetSeq().GetInst().CanGetLength() ) {
        return retval;
    }
    retval = GetQuery().GetSeq().GetInst().GetLength();
    return retval;
}

void
CPssm::GetQuerySequenceData(CNCBIstdaa& retval) const
{
    retval.Set().clear();
    if ( !CanGetQuery() ||
         !GetQuery().IsSeq() ||
         !GetQuery().GetSeq().CanGetInst() ||
         !GetQuery().GetSeq().GetInst().CanGetSeq_data() ) {
        return;
    }
    const CSeq_data& seq_data = GetQuery().GetSeq().GetInst().GetSeq_data();
    retval.Set().reserve(GetQueryLength());
    if ( !seq_data.IsNcbistdaa() ) {
        CSeq_data ncbistdaa;
        CSeqportUtil::Convert(seq_data, &ncbistdaa, CSeq_data::e_Ncbistdaa);
        copy(ncbistdaa.GetNcbistdaa().Get().begin(), 
             ncbistdaa.GetNcbistdaa().Get().end(),
             back_inserter(retval.Set()));
    } else {
        copy(seq_data.GetNcbistdaa().Get().begin(),
             seq_data.GetNcbistdaa().Get().end(),
             back_inserter(retval.Set()));
    }
}

double
CPssm::GetLambda() const
{
    if ( !CanGetFinalData() || !GetFinalData().CanGetLambda() ) {
        return kInvalidStat;
    }
    return GetFinalData().GetLambda();
}

double
CPssm::GetKappa() const
{
    if ( !CanGetFinalData() || !GetFinalData().CanGetKappa() ) {
        return kInvalidStat;
    }
    return GetFinalData().GetKappa();
}

double
CPssm::GetH() const
{
    if ( !CanGetFinalData() || !GetFinalData().CanGetH() ) {
        return kInvalidStat;
    }
    return GetFinalData().GetH();
}

double
CPssm::GetLambdaUngapped() const
{
    if ( !CanGetFinalData() || !GetFinalData().CanGetLambdaUngapped() ) {
        return kInvalidStat;
    }
    return GetFinalData().GetLambdaUngapped();
}

double
CPssm::GetKappaUngapped() const
{
    if ( !CanGetFinalData() || !GetFinalData().CanGetKappaUngapped() ) {
        return kInvalidStat;
    }
    return GetFinalData().GetKappaUngapped();
}

double
CPssm::GetHUngapped() const
{
    if ( !CanGetFinalData() || !GetFinalData().CanGetHUngapped() ) {
        return kInvalidStat;
    }
    return GetFinalData().GetHUngapped();
}

const double CPssm::kInvalidStat = 0.0;

void 
CPssm::SetLambda(double val)
{
    SetFinalData().SetLambda(val);
}

void 
CPssm::SetKappa(double val)
{
    SetFinalData().SetKappa(val);
}

void 
CPssm::SetH(double val)
{
    SetFinalData().SetH(val);
}

void 
CPssm::SetLambdaUngapped(double val)
{
    SetFinalData().SetLambdaUngapped(val);
}

void 
CPssm::SetKappaUngapped(double val)
{
    SetFinalData().SetKappaUngapped(val);
}

void 
CPssm::SetHUngapped(double val)
{
    SetFinalData().SetHUngapped(val);
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1711, CRC32: bcca969d */
