// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, RegionIter};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "GtkSourceRegion")]
    pub struct Region(Object<ffi::GtkSourceRegion, ffi::GtkSourceRegionClass>);

    match fn {
        type_ => || ffi::gtk_source_region_get_type(),
    }
}

impl Region {
    pub const NONE: Option<&'static Region> = None;

    #[doc(alias = "gtk_source_region_new")]
    pub fn new(buffer: &impl IsA<gtk::TextBuffer>) -> Region {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_source_region_new(buffer.as_ref().to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Region`] objects.
    ///
    /// This method returns an instance of [`RegionBuilder`](crate::builders::RegionBuilder) which can be used to create [`Region`] objects.
    pub fn builder() -> RegionBuilder {
        RegionBuilder::new()
    }
}

impl Default for Region {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Region`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct RegionBuilder {
    builder: glib::object::ObjectBuilder<'static, Region>,
}

impl RegionBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn buffer(self, buffer: &impl IsA<gtk::TextBuffer>) -> Self {
        Self {
            builder: self.builder.property("buffer", buffer.clone().upcast()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Region`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Region {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}

pub trait RegionExt: IsA<Region> + 'static {
    #[doc(alias = "gtk_source_region_add_region")]
    fn add_region(&self, region_to_add: Option<&impl IsA<Region>>) {
        unsafe {
            ffi::gtk_source_region_add_region(
                self.as_ref().to_glib_none().0,
                region_to_add.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_region_add_subregion")]
    fn add_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter) {
        unsafe {
            ffi::gtk_source_region_add_subregion(
                self.as_ref().to_glib_none().0,
                _start.to_glib_none().0,
                _end.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_region_get_bounds")]
    #[doc(alias = "get_bounds")]
    fn bounds(&self) -> Option<(gtk::TextIter, gtk::TextIter)> {
        unsafe {
            let mut start = gtk::TextIter::uninitialized();
            let mut end = gtk::TextIter::uninitialized();
            let ret = from_glib(ffi::gtk_source_region_get_bounds(
                self.as_ref().to_glib_none().0,
                start.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            ));
            if ret {
                Some((start, end))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_source_region_get_buffer")]
    #[doc(alias = "get_buffer")]
    fn buffer(&self) -> Option<gtk::TextBuffer> {
        unsafe {
            from_glib_none(ffi::gtk_source_region_get_buffer(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_region_get_start_region_iter")]
    #[doc(alias = "get_start_region_iter")]
    fn start_region_iter(&self) -> RegionIter {
        unsafe {
            let mut iter = RegionIter::uninitialized();
            ffi::gtk_source_region_get_start_region_iter(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            );
            iter
        }
    }

    #[doc(alias = "gtk_source_region_intersect_region")]
    #[must_use]
    fn intersect_region(&self, region2: Option<&impl IsA<Region>>) -> Option<Region> {
        unsafe {
            from_glib_full(ffi::gtk_source_region_intersect_region(
                self.as_ref().to_glib_none().0,
                region2.map(|p| p.as_ref()).to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_region_intersect_subregion")]
    #[must_use]
    fn intersect_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter) -> Option<Region> {
        unsafe {
            from_glib_full(ffi::gtk_source_region_intersect_subregion(
                self.as_ref().to_glib_none().0,
                _start.to_glib_none().0,
                _end.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_region_is_empty")]
    fn is_empty(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_region_is_empty(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_region_subtract_region")]
    fn subtract_region(&self, region_to_subtract: Option<&impl IsA<Region>>) {
        unsafe {
            ffi::gtk_source_region_subtract_region(
                self.as_ref().to_glib_none().0,
                region_to_subtract.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_region_subtract_subregion")]
    fn subtract_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter) {
        unsafe {
            ffi::gtk_source_region_subtract_subregion(
                self.as_ref().to_glib_none().0,
                _start.to_glib_none().0,
                _end.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_region_to_string")]
    #[doc(alias = "to_string")]
    fn to_str(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_source_region_to_string(
                self.as_ref().to_glib_none().0,
            ))
        }
    }
}

impl<O: IsA<Region>> RegionExt for O {}
